/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.VWPrivilegedActionHelper;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class VWXLIFFHandler
implements Serializable {
    private static final long serialVersionUID = 467L;
    private static final String XML_PREAMBLE = "<?xml version='1.0' encoding='UTF-8'?>\n<xliff version='1.1'\n\t xmlns='urn:oasis:names:tc:xliff:document:1.1'\n\t xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n\t xsi:schemaLocation='urn:oasis:names:tc:xliff:document:1.1 xliff-core-1.1.xsd'>\n";
    private static final String FILE_INDENT = "\t";
    private static final String BODY_INDENT = "\t\t";
    private static final String TRANS_INDENT = "\t\t\t";
    private static final String SRC_INDENT = "\t\t\t\t";
    private static final String KEY_TYPE_AUTHORED = "authored_keys";
    private static final String KEY_TYPE_LOCALIZED = "localized_keys";
    private static final String FILE_NAME_PREFIX = "PEAuthoredNames";
    private static final String FILE_EXTENSION = ".xliff";
    private static final String JAR_FILE_NAME = "PEAuthoredNames.jar";
    private static final String JPROP_USER_HOME = "user.home";
    private static final String JPROP_USER_DIR = "user.dir";
    private static final String JPROP_JAVA_HOME = "java.home";
    private static Logger m_logger = Logger.getLogger("filenet.vw.base");
    private static Hashtable m_regionList = null;
    private Integer m_nRegionId = null;

    public VWXLIFFHandler(int nRegionId) throws VWException {
        if (nRegionId < 1 || nRegionId > 999) {
            throw new VWException("filenet.vw.base.VWXLIFFHandler.InvalidRegionId", "The region id ({0}) is invalid.", Integer.toString(nRegionId));
        }
        this.m_nRegionId = new Integer(nRegionId);
    }

    public String getAuthoredString(Locale targetLocale, String localizedString) throws VWException {
        this.checkLocale(targetLocale);
        Hashtable list = this.getList(targetLocale, KEY_TYPE_LOCALIZED);
        if (list != null && list.containsKey(localizedString)) {
            return (String)list.get(localizedString);
        }
        return localizedString;
    }

    public String getDefaultFileName(Locale targetLocale, boolean bIncludeCountry) throws VWException {
        this.checkLocale(targetLocale);
        if (bIncludeCountry && targetLocale.getCountry() != null && targetLocale.getCountry().length() > 0) {
            return "PEAuthoredNames_" + this.m_nRegionId + "_" + targetLocale.getLanguage() + "_" + targetLocale.getCountry() + FILE_EXTENSION;
        }
        return "PEAuthoredNames_" + this.m_nRegionId + "_" + targetLocale.getLanguage() + FILE_EXTENSION;
    }

    public String getLocalizedString(Locale targetLocale, String authoredName) throws VWException {
        this.checkLocale(targetLocale);
        Hashtable list = this.getList(targetLocale, KEY_TYPE_AUTHORED);
        if (list != null && list.containsKey(authoredName)) {
            return (String)list.get(authoredName);
        }
        return authoredName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeStringsToFile(Locale sourceLocale, String[] keys, Locale targetLocale, String filePath) throws VWException {
        FileOutputStream outStream = null;
        this.checkLocale(sourceLocale);
        this.checkLocale(targetLocale);
        try {
            try {
                outStream = new FileOutputStream(filePath);
                StringBuffer buffer = new StringBuffer(XML_PREAMBLE);
                buffer.append("\t<file source-language='" + sourceLocale.getLanguage() + "' " + "target-language" + "='" + targetLocale.getLanguage() + "' " + "datatype" + "='plaintext' " + "original" + "=''>\n");
                buffer.append("\t\t<body>\n");
                int nCount = 0;
                Hashtable list = this.getList(targetLocale, KEY_TYPE_AUTHORED);
                if (list != null && keys != null) {
                    for (int i = 0; i < keys.length; ++i) {
                        if (keys[i] == null || keys[i].length() == 0) continue;
                        String safeKey = XMLHelper.toXMLString(keys[i]);
                        String safeValue = safeKey.toString();
                        if (list.containsKey(keys[i])) {
                            safeValue = XMLHelper.toXMLString((String)list.get(keys[i]));
                        }
                        buffer.append("\t\t\t<trans-unit id='" + ++nCount + "'>\n");
                        buffer.append("\t\t\t\t<source>" + safeKey + "</" + "source" + ">\n");
                        buffer.append("\t\t\t\t<target>" + safeValue + "</" + "target" + ">\n");
                        buffer.append("\t\t\t</trans-unit>\n");
                    }
                }
                buffer.append("\t\t</body>\n");
                buffer.append("\t</file>\n");
                buffer.append("</xliff>\n");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, "UTF8");
                out.write(buffer.toString());
                ((Writer)out).flush();
            }
            catch (Exception ex) {
                m_logger.log(Level.SEVERE, "VWXLIFFHandler::ErrorWritingToFile.", ex);
                throw new VWException("filenet.vw.api.VWXLIFFHandler.ErrorWritingToFile", "Exception writing XML to file: {0}.", ex.getLocalizedMessage());
            }
            Object var13_14 = null;
            if (outStream == null) return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (outStream == null) throw throwable;
            try {
                ((OutputStream)outStream).close();
                throw throwable;
            }
            catch (Exception ex1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex1) {}
        ((OutputStream)outStream).close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] verifyXliffFile(String filePath) throws VWException {
        String[] stringArray;
        FileInputStream inStream = null;
        try {
            try {
                inStream = new FileInputStream(filePath);
                InputStreamReader isr = new InputStreamReader((InputStream)inStream, "UTF8");
                BufferedReader bufferedReader = new BufferedReader(isr);
                InputSource inputSource = new InputSource(bufferedReader);
                Hashtable authoredKeyList = new Hashtable();
                Hashtable localizedKeyList = new Hashtable();
                stringArray = this.parseXliffFile(inputSource, authoredKeyList, localizedKeyList);
                Object var10_11 = null;
                if (inStream == null) return stringArray;
            }
            catch (Exception ex) {
                VWException theException = new VWException("filenet.vw.base.VWXLIFFHandler.XLIFFReadFromFileError", "Exception reading XLIFF file: {0}.", ex.getLocalizedMessage());
                theException.setCause(ex);
                throw theException;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (inStream == null) throw throwable;
            try {
                ((InputStream)inStream).close();
                throw throwable;
            }
            catch (Exception ex2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ex2) {
            // empty catch block
            return stringArray;
        }
        ((InputStream)inStream).close();
        return stringArray;
    }

    protected static String _get_FILE_DATE() {
        return "$Date:   30 Jan 2007 13:47:20  $";
    }

    protected static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    protected static String _get_FILE_REVISION() {
        return "$Revision:   1.10  $";
    }

    private void checkLocale(Locale locale) throws VWException {
        if (locale == null) {
            throw new VWException("filenet.vw.base.VWXLIFFHandler.LocaleIsNull", "The locale is null.");
        }
    }

    private synchronized Hashtable getList(Locale locale, String keyType) throws VWException {
        try {
            Hashtable keyList;
            Hashtable localeList;
            if (m_regionList == null) {
                m_regionList = new Hashtable(1);
            }
            if (!m_regionList.containsKey(this.m_nRegionId)) {
                m_regionList.put(this.m_nRegionId, new Hashtable(1));
            }
            if (!(localeList = (Hashtable)m_regionList.get(this.m_nRegionId)).containsKey(locale)) {
                localeList.put(locale, new Hashtable(2));
            }
            if (!(keyList = (Hashtable)localeList.get(locale)).containsKey(keyType)) {
                return this.readXliffFile(keyList, locale, keyType);
            }
            return (Hashtable)keyList.get(keyType);
        }
        catch (Exception ex) {
            m_logger.log(Level.SEVERE, "VWXLIFFHandler::ErrorRetrievingList.", ex);
            VWException theException = new VWException("filenet.vw.api.VWXLIFFHandler.ErrorRetrievingList", "Exception the list for locale: {0} - {1}.", locale, ex.getLocalizedMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable readXliffFile(Hashtable keyList, Locale locale, String keyType) throws VWException {
        Hashtable resultTable = null;
        InputStream inStream = null;
        try {
            try {
                InputStreamReader isr;
                BufferedReader bufferedReader;
                InputSource inputSource;
                String[] warnings;
                Hashtable authoredKeyList = new Hashtable(1);
                Hashtable localizedKeyList = new Hashtable(1);
                keyList.put(KEY_TYPE_AUTHORED, authoredKeyList);
                keyList.put(KEY_TYPE_LOCALIZED, localizedKeyList);
                resultTable = keyType.compareTo(KEY_TYPE_AUTHORED) == 0 ? authoredKeyList : localizedKeyList;
                inStream = this.getXliffResourceAsStream(locale);
                if (inStream != null && (warnings = this.parseXliffFile(inputSource = new InputSource(bufferedReader = new BufferedReader(isr = new InputStreamReader(inStream, "UTF8"))), authoredKeyList, localizedKeyList)) != null) {
                    for (int i = 0; i < warnings.length; ++i) {
                        m_logger.log(Level.WARNING, warnings[i]);
                    }
                }
                Object var14_15 = null;
                if (inStream == null) return resultTable;
            }
            catch (Exception ex) {
                m_logger.log(Level.SEVERE, "VWXLIFFHandler::ErrorReadingFile.", ex);
                VWException theException = new VWException("filenet.vw.api.VWXLIFFHandler.ErrorReadingFile", "Exception reading XLIFF file, {0}.", ex.getLocalizedMessage());
                theException.setCause(ex);
                throw theException;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (inStream == null) throw throwable;
            try {
                inStream.close();
                throw throwable;
            }
            catch (Exception ex1) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex1) {}
        inStream.close();
        return resultTable;
    }

    private InputStream getXliffResourceAsStream(Locale locale) throws VWException {
        InputStream inStream = this.findBundleOnClasspath(null, locale);
        if (inStream != null) {
            return inStream;
        }
        inStream = this.findInAPropertiedDirectory(JPROP_USER_HOME, locale);
        if (inStream != null) {
            return inStream;
        }
        inStream = this.findInAPropertiedDirectory(JPROP_USER_DIR, locale);
        if (inStream != null) {
            return inStream;
        }
        inStream = this.findInAPropertiedDirectory(JPROP_JAVA_HOME, locale);
        if (inStream != null) {
            return inStream;
        }
        String message = "VWXLIFFHandler - Could not find PEAuthoredNames_" + this.m_nRegionId + " XLIFF file! Locale = " + locale;
        m_logger.log(Level.INFO, message);
        return null;
    }

    private InputStream findInAPropertiedDirectory(String propertyName, Locale locale) {
        String directory = null;
        try {
            directory = VWPrivilegedActionHelper.getPrivilegedJavaProperty(propertyName);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (directory == null || directory.length() == 0) {
            return null;
        }
        try {
            m_logger.log(Level.INFO, "VWXLIFFHandler::findInAPropertiedDirectory - " + directory);
            File fullNameInThisDir = new File(directory, JAR_FILE_NAME);
            if (fullNameInThisDir.canRead()) {
                return this.findBundleOnClasspath(fullNameInThisDir.toURL(), locale);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return null;
    }

    private InputStream findBundleOnClasspath(URL url, Locale locale) {
        InputStream inStream;
        ClassLoader classLoader;
        try {
            m_logger.log(Level.INFO, "VWXLIFFHandler::findBundleOnClasspath - Trying privileged class loader.");
            classLoader = VWPrivilegedActionHelper.getPrivilegedClassLoader(this.getClass(), url);
            inStream = this.loadXliffUsingClassPath(classLoader, locale);
            if (inStream != null) {
                return inStream;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            m_logger.log(Level.INFO, "VWXLIFFHandler::findBundleOnClasspath - Trying privileged system class loader.");
            classLoader = VWPrivilegedActionHelper.getPrivilegedSystemClassLoader(url);
            inStream = this.loadXliffUsingClassPath(classLoader, locale);
            if (inStream != null) {
                return inStream;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            m_logger.log(Level.INFO, "VWXLIFFHandler::findBundleOnClasspath - Trying thread class loader.");
            classLoader = VWPrivilegedActionHelper.getPrivilegedThreadClassLoader(url);
            inStream = this.loadXliffUsingClassPath(classLoader, locale);
            if (inStream != null) {
                return inStream;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private InputStream loadXliffUsingClassPath(ClassLoader classLoader, Locale locale) throws VWException {
        String fileName = this.getDefaultFileName(locale, true);
        InputStream inStream = classLoader.getResourceAsStream(fileName);
        if (inStream == null) {
            fileName = this.getDefaultFileName(locale, false);
            inStream = classLoader.getResourceAsStream(fileName);
        }
        if (inStream != null) {
            m_logger.log(Level.INFO, "VWXLIFFHandler - Loading file: " + fileName);
        }
        return inStream;
    }

    private String[] parseXliffFile(InputSource inputSource, Hashtable authoredKeyList, Hashtable localizedKeyList) throws Exception {
        try {
            VWXMLWrapper xmlWrapper = new VWXMLWrapper(inputSource, null);
            if (xmlWrapper != null) {
                Node documentNode = xmlWrapper.getRootNode();
                if (documentNode == null || "xliff".compareTo(documentNode.getNodeName()) != 0) {
                    throw new VWException("filenet.vw.api.VWXLIFFHandler.NoXliffTag", "''xliff'' tag not found.");
                }
                if ((documentNode = VWXMLWrapper.getNodeNamed(documentNode, "file")) == null) {
                    throw new VWException("filenet.vw.api.VWXLIFFHandler.NoFileTag", "''file'' tag not found.");
                }
                if ((documentNode = VWXMLWrapper.getNodeNamed(documentNode, "body")) == null) {
                    throw new VWException("filenet.vw.api.VWXLIFFHandler.NoBodyTag", "''body'' tag not found.");
                }
                Node[] childNodes = VWXMLWrapper.getNodesNamed(documentNode, "trans-unit");
                if (childNodes != null) {
                    VWString message;
                    Vector<String> warningVec = new Vector<String>();
                    for (int i = 0; i < childNodes.length; ++i) {
                        String key = VWXMLWrapper.getNodeValue(childNodes[i], "source");
                        if (key != null && key.length() > 0) {
                            VWString message2;
                            String value = VWXMLWrapper.getNodeValue(childNodes[i], "target");
                            if (value != null && value.length() > 0) {
                                authoredKeyList.put(key, value);
                                if (localizedKeyList.containsKey(value)) {
                                    message2 = new VWString("filenet.vw.api.VWXLIFFHandler.DuplicateTargetValue", "Duplicate target value in the XLIFF file: source value=\"{0}\" target value=\"{1}\"");
                                    warningVec.addElement(message2.toString(key, value));
                                    continue;
                                }
                                localizedKeyList.put(value, key);
                                continue;
                            }
                            message2 = new VWString("filenet.vw.api.VWXLIFFHandler.InvalidValue", "Invalid value in the XLIFF file for key: \"{0}\"");
                            warningVec.addElement(message2.toString(key));
                            authoredKeyList.put(key, key);
                            continue;
                        }
                        message = new VWString("filenet.vw.api.VWXLIFFHandler.InvalidKey", "Invalid key in the XLIFF file: \"{0}\"");
                        warningVec.addElement(message.toString(key));
                    }
                    Enumeration values = authoredKeyList.elements();
                    while (values.hasMoreElements()) {
                        String value = (String)values.nextElement();
                        if (!authoredKeyList.containsKey(value) || value.compareTo((String)authoredKeyList.get(value)) == 0) continue;
                        message = new VWString("filenet.vw.api.VWXLIFFHandler.TargetMatchesSource", "Target value matches another source value in the XLIFF file: target value=\"{0}\"");
                        warningVec.addElement(message.toString(value));
                    }
                    if (warningVec.size() > 0) {
                        Object[] warnings = new String[warningVec.size()];
                        warningVec.copyInto(warnings);
                        return warnings;
                    }
                }
            }
        }
        catch (SAXParseException saxEx) {
            VWString parsingError = new VWString("filenet.vw.base.vwxliffhandler.parsingError", "** Parsing error");
            VWString line = new VWString("filenet.vw.base.vwxliffhandler.line", "line");
            String errString = parsingError + ", " + line + " " + saxEx.getLineNumber() + ", uri " + saxEx.getSystemId() + "\n" + "   " + saxEx.getMessage();
            VWException theException = new VWException("filenet.vw.api.VWXLIFFHandler.XLIFFReadParse", "XLIFF parsing error {0}.", errString);
            theException.setCause(saxEx);
            throw theException;
        }
        return null;
    }
}

